/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 4 BIT MAGNITUDE COMPARATOR 
TRUTHTABLE     : 

        -------------------------------------------------------
         DATA                         
         A, B    A>Bin  A<Bin  A=Bin   A>Bout  A<Bout  A=Bout
        -------------------------------------------------------
         A > B     X      X      X        H       L       L 
         A < B     X      X      X        L       H       L

         A = B     L      L      H        L       L       H
         A = B     L      H      L        L       H       L
         A = B     H      L      L        H       L       L 

         A = B     X      X      H        L       L       H
         A = B     H      H      L        L       L       L
         A = B     L      L      L        H       H       L 
        ------------------------------------------------------- 

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a85 (q3, ipltq, ipeqq, ipgtq, opgtq, opeqq, opltq, q0, p0, q1, p1, p2, q2, p3);
	parameter size =1;
	parameter cds_action = "ignore";
	input
		q3,
		ipltq,
		ipeqq,
		ipgtq,
		q0,
		p0,
		q1,
		p1,
		p2,
		q2,
		p3;
	output
		opgtq,
		opeqq,
		opltq;
    nand
	M85_inst_NA1 (m85_inst_wna1, p3, q3);
    nand
	M85_inst_NA2 (m85_inst_wna2, p2, q2);
    nand
	M85_inst_NA3 (m85_inst_wna3, p1, q1);
    nand
	M85_inst_NA4 (m85_inst_wna4, p0, q0);
    and
	M85_inst_AG9 (m85_inst_wa9, q3, m85_inst_wna1);
    and
	M85_inst_AG10 (m85_inst_wa10, q2, m85_inst_wna2, m85_inst_wn1);
    and
	M85_inst_AG11 (m85_inst_wa11, q1, m85_inst_wna3, m85_inst_wn1, m85_inst_wn2);
    and
	M85_inst_AG12 (m85_inst_wa12, q0, m85_inst_wna4, m85_inst_wn1, m85_inst_wn2, m85_inst_wn3);
    and
	M85_inst_AG13 (m85_inst_wa13, m85_inst_wn1, m85_inst_wn2, m85_inst_wn3, m85_inst_wn4, ipltq);
    and
	M85_inst_AG14 (m85_inst_wa14, m85_inst_wn1, m85_inst_wn2, m85_inst_wn3, m85_inst_wn4, ipeqq);
    and
	M85_inst_AG15 (m85_inst_wa15, ipeqq, m85_inst_wn4, m85_inst_wn3, m85_inst_wn2, m85_inst_wn1);
    and
	M85_inst_AG16 (m85_inst_wa16, ipgtq, m85_inst_wn4, m85_inst_wn2, m85_inst_wn3, m85_inst_wn1);
    and
	M85_inst_AG17 (m85_inst_wa17, m85_inst_wn3, m85_inst_wn2, m85_inst_wn1, m85_inst_wna4, p0);
    and
	M85_inst_AG18 (m85_inst_wa18, m85_inst_wn2, m85_inst_wn1, m85_inst_wna3, p1);
    and
	M85_inst_AG19 (m85_inst_wa19, m85_inst_wn1, m85_inst_wna2, p2);
    and
	M85_inst_AG20 (m85_inst_wa20, m85_inst_wna1, p3);
    and  
	M85_inst_AG21 (opeqq, m85_inst_wn1, m85_inst_wn2, ipeqq, m85_inst_wn3, m85_inst_wn4);
    nor  
	M85_inst_N5 (opgtq, m85_inst_wa9, m85_inst_wa10, m85_inst_wa11, m85_inst_wa12, m85_inst_wa13, m85_inst_wa14);
    nor  
	M85_inst_N6 (opltq, m85_inst_wa15, m85_inst_wa16, m85_inst_wa17, m85_inst_wa18, m85_inst_wa19, m85_inst_wa20);
    U_AOI_2_2
	M85_inst_INST1_inst1 (m85_inst_wn1, p3, m85_inst_wna1, m85_inst_wna1, q3);
    U_AOI_2_2
	M85_inst_INST2_inst1 (m85_inst_wn2, p2, m85_inst_wna2, m85_inst_wna2, q2);
    U_AOI_2_2
	M85_inst_INST3_inst1 (m85_inst_wn3, p1, m85_inst_wna3, m85_inst_wna3, q1);
    U_AOI_2_2
	M85_inst_INST4_inst1 (m85_inst_wn4, p0, m85_inst_wna4, m85_inst_wna4, q0);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
